/*
 *  Juggle version 1.0, Copyright (C) 1995 G. Hutchings
 *  Juggle comes with ABSOLUTELY NO WARRANTY.
 *  This is free software, and you are welcome to redistribute it
 *  under certain conditions; see the file COPYING for details.
 */

/* Interface to GL graphics library */

#ifndef lint
static char rcsid[] = "$Id: gl.c,v 1.5 1995/03/30 15:51:46 g_hutchi Exp $";
#endif

#include <stdio.h>
#include <ctype.h>
#include <gl.h>
#include <gl/device.h>
#include "juggle.h"

#define BALL_SIZE	1/20.0	/* Ball size compared to window */
#define BORDER		0.1	/* Border size */
#define MAX_STEP	0.3	/* Maximum step size */
#define MIN_STEP	0.01	/* Minimum step size */
#define BASE_COLOUR	8	/* Lowest definable colour */
#define COLOURS		10	/* No. of ball colours */

#define COLOUR(n)	color(BASE_COLOUR+(n))

long win;			/* Window ID */

short rgb[COLOURS][3] = {
    0,   0,   0,		/* Black (background) */
    255, 255, 0,		/* Yellow */
    0,   0,   255,		/* Blue */
    255, 0,   0,		/* Red */
    0,   255, 0,		/* Green */
    255, 0,   255,		/* Purple */
    255, 126, 29,		/* Orange */
    128, 79,  29,		/* Brown */
    255, 59,  146,		/* Pink */
    255, 255, 255,		/* White */
};

void
juggle_init()
{
    int i, j, tmp, rnd[COLOURS], nswaps = 100;
    char title[BUFSIZ];

    /* Create title */
    if (juggle_name == NULL) {
	sprintf(title, " Pattern %s ", juggle_pattern);
    } else {
	sprintf(title, " %s (%s) ", juggle_name, juggle_pattern);
    }

    /* Initialise window */
    if (juggle_debug) foreground();
    minsize(200, 200);
    win = winopen(title);

    /* Set graphics state */
    doublebuffer();
    gconfig();

    /* Queue devices */
    qdevice(KEYBD);
    qdevice(REDRAW);
    qdevice(WINQUIT);
    qdevice(WINSHUT);

    /* Randomize colours */
    for (i = 0; i < COLOURS; i++) rnd[i] = i;
    while (nswaps-- > 0) {
	i = RANDOM(COLOURS-1)+1;
	j = RANDOM(COLOURS-1)+1;
	SWAP(rnd[i], rnd[j]);
    }

    /* Set up colour map */
    for (i = 0; i < COLOURS; i++)
	mapcolor(BASE_COLOUR+rnd[i], rgb[i][0], rgb[i][1], rgb[i][2]);

    /* Set view */
    ortho2(-BORDER, 1 + BORDER, -BORDER, 1 + BORDER);

    /* Set default timestep */
    juggle_set_step(0.05, 0);
}

void
juggle_frame()
{
    COLOUR(0);
    clear();
}

void
juggle_ball(int num, int throw, int catch, double x, double y)
{
    int col = 1 + (num % (COLOURS - 1));

    COLOUR(col);
    circf(x, y, BALL_SIZE);
}

void
juggle_update()
{
    swapbuffers();
}

int
juggle_quit()
{
    short data;
    double fac, step;

    if (qtest()) {
	switch (qread(&data)) {
	case KEYBD:
	    switch (data) {
	    case 'q':
		/* Quit */
		return 1;
		break;
	    case 'h':
		/* Toggle ball holding */
		juggle_hold = !juggle_hold;
		break;
	    case '+':
	    case '-':
		/* Increase/decrease step size */
		fac = (MAX_STEP-MIN_STEP)/10;
		step = juggle_step;
		step += (data == '+' ? fac : -fac);
		step = MAX(step, MIN_STEP);
		step = MIN(step, MAX_STEP);
		juggle_set_step(step, 1);
		break;
	    default:
		if (isdigit(data)) {
		    /* Set step size */
		    fac = (data - '0') / 9.0;
		    step = MIN_STEP + (MAX_STEP - MIN_STEP) * fac;
		    juggle_set_step(step, 1);
		} else {
		    ringbell();
		}
		break;
	    }
	    break;
	case REDRAW:
	    reshapeviewport();
	    break;
	case WINSHUT:
	case WINQUIT:
	    return 1;
	}
    }

    return 0;
}

void
juggle_end()
{
    winclose(win);
}
