/*
 *  Juggle version 1.0, Copyright (C) 1995 G. Hutchings
 *  Juggle comes with ABSOLUTELY NO WARRANTY.
 *  This is free software, and you are welcome to redistribute it
 *  under certain conditions; see the file COPYING for details.
 */

/* Simple no-frills curses interface to Juggle */

#ifndef lint
static char rcsid[] = "$Id: curses.c,v 1.2 1995/03/30 15:46:12 g_hutchi Exp $";
#endif

#include <curses.h>
#include <signal.h>
#include "juggle.h"

#define X_BORDER	20
#define Y_BORDER	2

void
juggle_init()
{
    char title[BUFSIZ];

    /* Set up screen */
    initscr();
    noecho();

    /* Catch interrupts */
    signal(SIGINT, juggle_end);

    /* Draw title */
    if (juggle_name == NULL) {
	sprintf(title, " Pattern %s ", juggle_pattern);
    } else {
	sprintf(title, " %s (%s) ", juggle_name, juggle_pattern);
    }

    standout();
    mvaddstr(0, (COLS - strlen(title)) / 2, title);
    standend();
}

void
juggle_frame()
{
    move(Y_BORDER - 1, 0);
    clrtobot();
}

void
juggle_ball(int num, int throw, int catch, double x, double y)
{
    int line = Y_BORDER + (LINES - 2 * Y_BORDER) * (1 - y);
    int col = X_BORDER + (COLS - 2 * X_BORDER) * x;
    static char buf[4];

    sprintf(buf, "(%d)", num + 1);
    mvaddstr(line, col - 1, buf);
}

void
juggle_update()
{
    refresh();
}

int
juggle_quit()
{
    /* You have to Control-C out of this one */
    return 0;
}

void
juggle_end()
{
    echo();
    mvcur(0, COLS - 1, LINES - 1, 0);
    endwin();
    exit(0);
}
